﻿/*  Author:     Ben Hall
 *  File:       MapMoveEvent.cs
 *  Date:       4/28/2011
 *  
 *  Purpose:    MapMoveEvent.cs extends the MapEvent class and is used to handle movement
 *              between maps at a given location.
 */

using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace OnlineGame
{
    public class MapMoveEvent : MapEvent
    {
        String mapIDToMoveTo;
        Position posToMoveTo;

        public MapMoveEvent(String mapIDToMoveToIn, Position posToMoveToIn)
        {
            this.mapIDToMoveTo = mapIDToMoveToIn;
            this.posToMoveTo = posToMoveToIn;
        }

        public String GetMapIDToMoveTo()
        {
            return this.mapIDToMoveTo;
        }

        public Position GetPositionToMoveTo()
        {
            return this.posToMoveTo;
        }
    }
}
